<?php


class Downloads_Importer {
	private $registry;
	
	public function __construct($registry) {
		$this->registry = $registry;
		
		set_time_limit(0);
	}
	
	public function fetchMods() {
		$gettables = $this->registry->db->query_read("
			SHOW TABLE STATUS
		");
		
		$foundmods = array();
		while ($tables = $this->registry->db->fetch_array($gettables)) {
			if ($tables['Name'] == TABLE_PREFIX . 'dl2_files') {
				$foundmods['dl2'] = 'DownloadsII';
			}
		}
		
		return $foundmods;
	}
	
	public function step1($mods=array()) {
		foreach ($mods AS $modid => $mod) {
			print_description_row('<span style="font-weight: bold;">' . $mod . '</span> was found on this server. Please press the button below to continue.', false, 1, 'alt1');
			
			$this->print_foot('<a href="vbdownloads.php?do=import&step=2&mod=' . $modid . '">[Import ' . $mod . ']</a>');
		}
	}
	
	private function print_foot($text) {
		echo'
			<tr>
				<td class="tfoot" colspan="2" style="text-align: center;">' . $text . '</td>
			</tr>	 
		';
	}
	
	public function step2($mod) {
		$filecount = $this->getFileCount($mod);
		
		if ($filecount > 0) {
			print_description_row('We found <span style="font-weight: bold;">' . $filecount . '</span> files for this mod. Press press the button below if you would like to import these to vBDownloads.');
			
			$this->print_foot('<a href="vbdownloads.php?do=import&step=3&mod=' . $mod . '">[Import Files]</a>');
		} else {
			print_description_row('We could not find any files to be imported.');
		}
	}
	
	private function getFileCount($mod) {
		switch ($mod) {
			case 'dl2':
				$table 	= TABLE_PREFIX . 'dl2_files';
				$column = 'id';
			break;
		}
		
		if ($table && $column) {
			$filecount = $this->registry->db->query_first("
				SELECT count($column) AS total FROM $table
			");
			
			return intval($filecount['total']);
		}
	}
	
	public function step3($mod) {
		print_form_header('vbdownloads', 'import&step=4&mod=' . $mod);
		
		echo '<input type="hidden" name="do" value="import" />';
		
		print_input_row('Path To Downloads Folder<dfn>This is the folder where the files for this mod are kept. Make sure this also has a trailing slash.<br />This is normally in the form of /home/user/downloads/', 'current');
		print_input_row('Path To Destination Folder<dfn>This is the folder where you want to move the files to. Make sure this also has a trailing slash.<br />This is normally in the form of /home/user/newdownloads/', 'destination');
		
		$this->print_foot('<input type="submit" value="Continue" />');
	}
	
	public function step4($current, $destination, $mod) {
		if (!is_dir($current) || !is_dir($destination)) {
			if (!is_dir($current)) {
				print_description_row('We could not detect the presence of <span style="font-weight: bold;">' . $current . '</span>. Please go back and make sure you entered the correct path.');
			}
			
			if (!is_dir($destination)) {
				print_description_row('We could not detect the presence of <span style="font-weight: bold;">' . $destination . '</span>. Please go back and make sure you entered the correct path.');
			}
		} else {
			echo '<input type="hidden" name="do" value="import" />';
			
			$this->createTempTables();
			$this->importCategories($mod);
			
			$this->registry->db->query_write("
				INSERT INTO " . TABLE_PREFIX . "dbtech_downloads_import_paths (oldpath, newpath)
				VALUES	(
							'" . $this->registry->db->escape_string($current) . "',
							'" . $this->registry->db->escape_string($destination) . "'
						)
			");
			
			$this->print_foot('<a href="vbdownloads.php?do=import&step=5&mod=' . $mod . '">[Continue]</a>');
		}
	}
	
	private function createTempTables() {
		$this->registry->db->query_write("
			CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "dbtech_downloads_import_category (
				oldcat 		INT(20) UNSIGNED NOT NULL, 
				dbtechcat 	INT(20) UNSIGNED NOT NULL
			)
		");
		
		$this->registry->db->query_write("
			DELETE FROM " . TABLE_PREFIX . "dbtech_downloads_import_category
		");
		
		$this->registry->db->query_write("
			CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "dbtech_downloads_import_paths (
				selecter INT(10) UNSIGNED DEFAULT '1',
				oldpath MEDIUMTEXT	NOT NULL,
				newpath	MEDIUMTEXT 	NOT NULL	
			)
		");
		
		$this->registry->db->query_write("
			DELETE FROM " . TABLE_PREFIX . "dbtech_downloads_import_paths
		");
	}
	
	private function importCategories($mod) {
		switch ($mod) {
			case 'dl2':
				$table = TABLE_PREFIX . 'dl2_categories';
			break;
		}
		
		$fetchcategorys = $this->registry->db->query_read("
			SELECT * FROM $table
		");
		
		$category_cache = array();
		
		if ($mod == 'dl2') {
			while ($category = $this->registry->db->fetch_array($fetchcategorys)) {
				$category_cache[$category['id']] = $category;
			}
		}

		$default_ugs = 'a:3:{s:4:"view";a:1:{i:0;i:6;}s:8:"download";a:1:{i:0;i:6;}s:6:"upload";a:1:{i:0;i:6;}}';

		foreach ($category_cache AS $categoryid => $category) {
			if ($categoryid > 0) {
				$this->registry->db->query_write("
					INSERT INTO " . TABLE_PREFIX . "dbtech_downloads_categories (catname, catdesc, extgroupids, permissions)
					VALUES	(
								'" . $this->registry->db->escape_string($category['name']) . "',
								'" . $this->registry->db->escape_string($category['description']) . "', 
								'2', 
								'" . $this->registry->db->escape_string($default_ugs) . "'
							)
				");
				
				$newid = $this->registry->db->insert_id();
				
				$this->registry->db->query_write("
					INSERT INTO " . TABLE_PREFIX . "dbtech_downloads_import_category (oldcat, dbtechcat)
					VALUES	(
								" . intval($categoryid) . ",
								" . intval($newid) . "
							)
				");

				print_description_row('Imported <span style="font-weight: bold;">' . $category['name'] . '</span>');
				usleep(200);
			}
		}

		if ($mod == 'dl2')
		{
			$fetchcatparent = $this->registry->db->query_read("
				SELECT id, parent FROM $table 
				WHERE parent > 0
			");

			while ($oldcatparent = $this->registry->db->fetch_array($fetchcatparent))
			{
				$newcatparent = $this->registry->db->query_first("
					SELECT dbtechcat FROM " . TABLE_PREFIX . "dbtech_downloads_import_category
					WHERE oldcat = " . intval($oldcatparent['parent'])
				);

				$newcatid = $this->registry->db->query_first("
					SELECT dbtechcat FROM " . TABLE_PREFIX . "dbtech_downloads_import_category
					WHERE oldcat = " . intval($oldcatparent['id'])
				);

				$this->registry->db->query_write("
					UPDATE " . TABLE_PREFIX . "dbtech_downloads_categories
					SET
						parentid 	= " . intval($newcatparent['dbtechcat']) . "
					WHERE
						catid 		= " . intval($newcatid['dbtechcat'])
				);
			}
		}

		print_description_row('Imported all categories successfully. Please press the button below.');
	}
	
	public function step5($start=0, $end=100, $mod) {
		$convert = $this->fetchCategoryConversions();
		
		$paths = $this->registry->db->query_first("
			SELECT * FROM " . TABLE_PREFIX . "dbtech_downloads_import_paths
			WHERE selecter = 1
		");
		
		$current 		= $paths['oldpath'];
		$destination 	= $paths['newpath'];
		
		if ($mod == 'dl2') {
			$getfileinfo = $this->registry->db->query_read("
				SELECT df.*, di.thumb FROM " . TABLE_PREFIX . "dl2_files df 
				LEFT JOIN " . TABLE_PREFIX . "dl2_images di ON df.id = di.file 
				ORDER BY df.id ASC 
				LIMIT " . $start . ", " . $end
			);
			
			$filecache = array();
			
			if ($this->registry->db->num_rows($getfileinfo) == 0) {
				print_cp_redirect('vbdownloads.php?do=import&step=6');
			} else {
				while ($file = $this->registry->db->fetch_array($getfileinfo)) {
					$filecache[] = $file;
				}
				
				foreach ($filecache AS $i => $file) {
                    if ($file['link'] == 1) {
                        $filecount = 0;

                        $mirrors = serialize(array($file['url']));
                    } else {
                        $filecount = 1;

                        $mirrors = '';
                    }

					$this->registry->db->query_write("
						INSERT INTO " . TABLE_PREFIX . "dbtech_downloads_filegroup (userid, groupname, groupdesc, files, updated, categoryid, mirrors)
						VALUES	(
									" . intval($file['uploaderid']) . ",
									'" . $this->registry->db->escape_string($file['title']) . "',
									'" . $this->registry->db->escape_string($file['description']) . "',
									$filecount,
									" . intval($file['dateadded']) . ",
									" . intval($convert[$file['category']]) . ",
									'" . $this->registry->db->escape_string($mirrors) . "'
								)
					");
					
					$parentid = intval($this->registry->db->insert_id());

					if ($file['thumb'])
					{
						$this->registry->db->query_write("
							UPDATE " . TABLE_PREFIX . "dbtech_downloads_filegroup
							SET
								image 		= '" . $this->registry->db->escape_string($file['thumb']) . "'
							WHERE
								groupid 	= " . intval($parentid)
						);

						copy($current . $file['thumb'], $destination . $fileid . '-' . $file['thumb']);
					}

                    if ($file['link'] == 1) {
                        $filename = $file['name'];
                    } else {
                        $filename = $file['url'];
                    }

					$this->registry->db->query_write("
						INSERT INTO " . TABLE_PREFIX . "dbtech_downloads_fileinfo (userid, filename, dateline, filesize, parentid)
						VALUES	(
									" . intval($file['uploaderid']) . ",
									'" . $this->registry->db->escape_string($filename) . "',
									" . intval($file['dateadded']) . ",
									" . intval($file['size']) . ",
									$parentid
								)
					");
				
					$fileid = intval($this->registry->db->insert_id());

					copy($current . $file['url'], $destination . $fileid . '-' . $file['url']);
				}
				
				usleep(1000);
				
				$run = intval($this->registry->GPC['run']);
				
				$run = $run + 1;
				
				print_cp_redirect('vbdownloads.php?do=import&step=5&mod=dl2&run=' . $run);
			}
		}
	}
	
	private function fetchCategoryConversions() {
		$fetchconversions = $this->registry->db->query_read("
			SELECT * FROM " . TABLE_PREFIX . "dbtech_downloads_import_category
		");
		
		$conversions = array();
		while ($categoryinfo = $this->registry->db->fetch_array($fetchconversions)) {
			$conversions[$categoryinfo['oldcat']] = $categoryinfo['dbtechcat'];
		}
		
		return $conversions;
	}
	
	public function step6() {
		$this->registry->db->query_write("
			DROP TABLE IF EXISTS " . TABLE_PREFIX . "dbtech_downloads_import_category
		");
		
		$this->registry->db->query_write("
			DROP TABLE IF EXISTS " . TABLE_PREFIX . "dbtech_downloads_import_paths
		");

		$categorys = $this->registry->db->query_read("
			SELECT * FROM " . TABLE_PREFIX . "dbtech_downloads_categories
		");
	
		$catcache = array();
		while ($cat = $this->registry->db->fetch_array($categorys)) {
			$catcache[$cat['catid']] = $cat;
		}
	
		build_datastore('dbtech_downloads_categories', serialize($catcache), true);

		print_description_row('Congratulations, you have successfully imported from this mod! Please configure the new categories that have been added to vBDownloads.');
	}
}

?>